% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAbin2kmerFreqMatrix.R
\name{DNAbin2kmerFreqMatrix}
\alias{DNAbin2kmerFreqMatrix}
\title{Calculation of Kmer Frequency Matrix from DNAbin for Both Reference and Query Sequences}
\usage{
DNAbin2kmerFreqMatrix(ref, que, kmer = kmer)
}
\arguments{
\item{ref}{Object of class "DNAbin" used as a reference dataset, which contains taxon information.}

\item{que}{Object of class "DNAbin", which needs to be inferred.}

\item{kmer}{a numeric to indicate the length of kmer used.}
}
\value{
kmer frequency matrices for both ref and que sequences, but only based on kmers found in ref!!!
new kmers in que will be ignored.
}
\description{
Calculation of kmer frequency matrices from DNAbin for both reference and query sequences.
}
\examples{
data(TibetanMoth) 
ref<-as.DNAbin(as.character(TibetanMoth[1:50,]))
que<-as.DNAbin(as.character(TibetanMoth[51:60,]))
out<-DNAbin2kmerFreqMatrix(ref,que,kmer=3)
out


}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA. zhangab2008(at)mail.cnu.edu.cn
}
\references{
zhangab2008(at)mail.cnu.edu.cn
}
\keyword{DNAbin2kmerFreqMatrix}

