/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.rosuda.JGR.JGR;

public class BiologicalInferencesTaxaNameDupITIS
extends JFrame {
    private JButton okButton;
    private JLabel title;
    private JLabel note;
    private JList taxaNameList;
    private JScrollPane taxaNameScrollPane;
    private String[] taxaName;
    private int numOfTaxa;
    private double messageDisplayNum;

    public BiologicalInferencesTaxaNameDupITIS() {
    }

    public BiologicalInferencesTaxaNameDupITIS(int num, String[] str, double displayNum) {
        this.numOfTaxa = num;
        this.taxaName = new String[this.numOfTaxa];
        this.taxaName = str;
        this.messageDisplayNum = displayNum;
        this.initComponents();
    }

    private void initComponents() {
        this.title = new JLabel();
        this.note = new JLabel();
        this.okButton = new JButton();
        this.taxaNameScrollPane = new JScrollPane();
        this.taxaNameList = new JList<String>(this.taxaName);
        this.setLocation(200, 200);
        this.setDefaultCloseOperation(3);
        this.setTitle("Biological Inferences");
        this.title.setFont(new Font("Tahoma", 0, 13));
        if (this.messageDisplayNum == 0.0) {
            this.title.setText("<html>The following taxa match with multiple ITIS records.<br /> Please select the appropriate taxon from list.</html>");
        } else {
            this.title.setText("<html>You either selected multiple records for one taxon <br />or did not select a record for one taxon.<br />Please select again!</html>");
        }
        this.note.setText("<html>Left \"column\" is the taxa name.<br /> Select one taxon from each of the duplicated choices.<br />Press Ctrl+ while selecting multiple lines.</html>");
        this.note.setBorder(BorderFactory.createTitledBorder("Note"));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferencesTaxaNameDupITIS.this.okButton1ActionPerformed(evt);
            }
        });
        this.taxaNameScrollPane.setViewportView(this.taxaNameList);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(114, 114, 114).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.okButton).addComponent(this.title).addComponent(this.note).addComponent(this.taxaNameScrollPane, -2, 375, -2)).addContainerGap(113, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.title).addGap(18, 18, 18).addComponent(this.taxaNameScrollPane, -1, 172, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.okButton).addGap(18, 18, 18).addComponent(this.note).addGap(19, 19, 19)));
        this.pack();
    }

    private void okButton1ActionPerformed(ActionEvent evt) {
        Object[] string = this.taxaNameList.getSelectedValues();
        String str = "";
        for (int i = 0; i < string.length; ++i) {
            str = i == string.length - 1 ? str + "\"" + string[i].toString() + "\"" : str + "\"" + string[i].toString() + "\"" + ",";
        }
        String cmd = "bioinfer.new.JGR(dupe.sel= c(" + str + "))";
        JGR.MAINRCONSOLE.execute(cmd, true);
        this.dispose();
    }

    private JFrame getMyGUI(int num, String[] str, double displayNum) {
        BiologicalInferencesTaxaNameDupITIS jf = new BiologicalInferencesTaxaNameDupITIS(num, str, displayNum);
        jf.setVisible(true);
        return jf;
    }
}

