% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{MaxErrorAt_CDF}
\alias{MaxErrorAt_CDF}
\title{Locate where the maximum error occurs between two CDFs}
\usage{
MaxErrorAt_CDF(Y, est, range, gran, ...)
}
\arguments{
\item{Y}{The vector output of a non-differentially private CDF 
computation (cumulative count bins)}

\item{est}{The vector output of a differentially private CDF
computation (cumulative count bins)}

\item{range}{A vector length 2 containing user-specified min and max to 
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] 
for a list of ages)}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A single value, the value at which the  largest absolute vertical
   difference between
  parallel observations in the private- and true-CDF vectors occurs.
}
\description{
Find the location of the maximum direct error between a 
   non-private CDF and a DP approximation of that CDF.
}
\examples{
MaxErrorAt_CDF(c(.1,.2,.3,.4,.5,.6,.7,.8,.9,1), c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1),
    range= c(1,10), gran =1)
}

