% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionFramework.R
\name{functionHmono}
\alias{functionHmono}
\title{Create a monotonically increasing DP-CDF by creating a K-degree noisy tree}
\usage{
functionHmono(eps, cdfstep, data, range, gran, K = 2, ...)
}
\arguments{
\item{eps}{Epsilon value for Differential privacy control}

\item{cdfstep}{The step sized used in outputting the approximate CDF; the values output are [min, min + cdfstep], [min, min + 2 * cdfstep], etc.}

\item{data}{A vector of the data (single variable to compute CDFs from)}

\item{range}{A vector length 2 containing user-specified min and max to truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] for a list of ages)}

\item{K}{This sets the degree of the underlying tree.}

\item{...}{Optionally add additional parameters.}
}
\value{
A list with 2 vectors: one is the y coordinates of the DP-CDF, the other is the
   abs values of the anlytically expected bounds for a similarly-constructed
   non-monotonized DP-CDF, at 95 percent probability.
}
\description{
This function creates a storage tree of degree K using gran and range,
 adds independent noise to each node proportional to epsilon, and then searches
 the tree to create a DP-CDF. It then enforces monotonicity on the resuling 
 dpCDF.
}
\examples{
functionHmono(eps = .01, cdfstep = .1, data = rexp(10000,.4), range= c(1,10), gran = .1, K= 2)
}

