% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modelKriging.R
\name{modelKrigingLikelihood}
\alias{modelKrigingLikelihood}
\title{Calculate negative log-likelihood}
\usage{
modelKrigingLikelihood(xt, dX, y, optimizeP = FALSE, useLambda = FALSE,
  corr = fcorrGauss)
}
\arguments{
\item{xt}{vector, containing log10(theta), p and lambda}

\item{dX}{matrix of distances/dissimilarites between training samples}

\item{y}{vector of observations at sample locations}

\item{optimizeP}{whether to optimize p or not (FALSE at default)}

\item{useLambda}{whether to use nugget effect, i.e., lambda (FALSE at default)}

\item{corr}{whether to use nugget effect, i.e., lambda (fcorrGauss at default)}
}
\value{
list with elements\cr
\code{NegLnLike}  concentrated log-likelihood *-1 for minimising \cr
\code{Psi} correlation matrix\cr
\code{Psinv} inverse of correlation matrix (to save computation time in forrRegPredictor)\cr
\code{mu} MLE of model parameter mu \cr
\code{yMu} vector of observations y minus mu\cr
\code{SSQ} MLE of model parameter sigma^2
}
\description{
Used to determine theta/lambda/p values for the Kriging model in \code{\link{modelKriging}}
with Maximum Likelihood Estimation (MLE).
}
\seealso{
\code{\link{modelKriging}}
}
\keyword{internal}

