% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceCalculation.R
\name{distanceMatrixUpdate}
\alias{distanceMatrixUpdate}
\title{Update distance matrix}
\usage{
distanceMatrixUpdate(distanceMat, x, distanceFunction, ...)
}
\arguments{
\item{distanceMat}{original distance matrix \code{D_mat}}

\item{x}{list of candidate solutions, last in list is the new solution}

\item{distanceFunction}{Distance function of type f(x,y)=r, where r is a scalar and x and y are candidate solutions whose distance is evaluated.}

\item{...}{further arguments passed to distanceFunction}
}
\value{
matrix of distances between all solutions x
}
\description{
Update an existing distance matrix \code{D_mat} by adding distances
of all previous candidate solutions to one new candidate solution, \code{d_vec= d(x_i,x_new)}.
}
\examples{
x <- list(5:1,c(2,4,5,1,3),c(5,4,3,1,2))
dm <- distanceMatrix(x,distancePermutationHamming)
x <- append(x,list(1:5))
dmUp <- distanceMatrixUpdate(dm,x,distancePermutationHamming)

}
\keyword{internal}
