% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootPaired.R, R/bootPaired.default.R,
%   R/bootPaired.formula.R
\name{bootPaired}
\alias{bootPaired}
\alias{bootPaired.default}
\alias{bootPaired.formula}
\title{Bootstrap paired data}
\usage{
bootPaired(x, ...)

\method{bootPaired}{default}(x, y, conf.level = 0.95, B = 10000,
  plot.hist = TRUE, plot.qq = FALSE, legend.loc = "topright",
  x.name = deparse(substitute(x)), y.name = deparse(substitute(y)),
  ...)

\method{bootPaired}{formula}(formula, data, subset, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector.}

\item{conf.level}{confidence level for the bootstrap percentile interval.}

\item{B}{number of resamples (positive integer greater than 2).}

\item{plot.hist}{logical. If \code{TRUE}, plot the histogram of the
bootstrap distribution.}

\item{plot.qq}{logical. If \code{TRUE}, a normal quantile-quantile plot of
the replicates will be created.}

\item{legend.loc}{location for the legend on the histogram. Options are
\code{"topright"} \code{"topleft"}, \code{"bottomleft"} and
\code{"bottomright"}.}

\item{x.name}{Label for variable x}

\item{y.name}{Label for variable y}

\item{formula}{a formula \code{y ~ x} where \code{x, y} are both numeric vectors}

\item{data}{a data frame that contains the variables given in the formula.}

\item{subset}{an optional expression indicating what observations to use.}
}
\value{
The command invisibly returns a vector with the replicates of the
statistic being bootstrapped.
}
\description{
Perform a bootstrap of two paired variables.
}
\details{
The command will compute the difference of \code{x} and \code{y} and
bootstrap the difference. The mean and standard error of the bootstrap
distribution will be printed as well as a bootstrap percentile interval.

Observations with missing values are removed.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Perform a bootstrap of two paired variables.

\item \code{formula}: Perform a bootstrap of two paired variables.
}}

\examples{

#Bootstrap the mean difference of fat content in vanilla and chocolate ice
#cream. Data are paired becaues ice cream from the same manufacturer will
#have similar content.
Icecream
bootPaired(ChocFat ~ VanillaFat, data = Icecream)
bootPaired(Icecream$VanillaFat, Icecream$ChocFat)

}
\references{
Tim Hesterberg's website
\url{http://www.timhesterberg.net/bootstrap}
}
\author{
Laura Chihara
}
\keyword{bootstrap}
\keyword{randomization}
\keyword{resampling}
