% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{predict_GMM}
\alias{predict_GMM}
\alias{predict.GMMCluster}
\title{Prediction function for a Gaussian Mixture Model object}
\usage{
predict_GMM(data, CENTROIDS, COVARIANCE, WEIGHTS)

\method{predict}{GMMCluster}(object, newdata, ...)
}
\arguments{
\item{data}{matrix or data frame}

\item{CENTROIDS}{matrix or data frame containing the centroids (means), stored as row vectors}

\item{COVARIANCE}{matrix or data frame containing the diagonal covariance matrices, stored as row vectors}

\item{WEIGHTS}{vector containing the weights}

\item{object, newdata, ...}{arguments for the `predict` generic}
}
\value{
a list consisting of the log-likelihoods, cluster probabilities and cluster labels.
}
\description{
Prediction function for a Gaussian Mixture Model object
}
\details{
This function takes the centroids, covariance matrix and weights from a trained model and returns the log-likelihoods, cluster probabilities and cluster labels for new data.
}
\examples{

data(dietary_survey_IBS)

dat = as.matrix(dietary_survey_IBS[, -ncol(dietary_survey_IBS)])

dat = center_scale(dat)

gmm = GMM(dat, 2, "maha_dist", "random_subset", 10, 10)

# pr = predict_GMM(dat, gmm$centroids, gmm$covariance_matrices, gmm$weights)

}
\author{
Lampros Mouselimis
}
