/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.WindowMenuUtil;

public final class DockingUtil {
    private DockingUtil() {
    }

    public static RootWindow createRootWindow(AbstractViewMap abstractViewMap, boolean bl) {
        return DockingUtil.createRootWindow(abstractViewMap, abstractViewMap, bl);
    }

    public static RootWindow createHeavyweightSupportedRootWindow(AbstractViewMap abstractViewMap, boolean bl) {
        return DockingUtil.createRootWindow(true, abstractViewMap, abstractViewMap, bl);
    }

    public static RootWindow createRootWindow(AbstractViewMap abstractViewMap, ViewSerializer viewSerializer, boolean bl) {
        return DockingUtil.createRootWindow(false, abstractViewMap, viewSerializer, bl);
    }

    public static RootWindow createHeavyweightSupportedRootWindow(AbstractViewMap abstractViewMap, ViewSerializer viewSerializer, boolean bl) {
        return DockingUtil.createRootWindow(true, abstractViewMap, viewSerializer, bl);
    }

    private static RootWindow createRootWindow(boolean bl, AbstractViewMap abstractViewMap, ViewSerializer viewSerializer, boolean bl2) {
        TabWindow tabWindow = new TabWindow();
        for (int i = 0; i < abstractViewMap.getViewCount(); ++i) {
            tabWindow.addTab(abstractViewMap.getViewAtIndex(i));
        }
        tabWindow.setSelectedTab(0);
        RootWindow rootWindow = new RootWindow(bl, viewSerializer, tabWindow);
        if (bl2) {
            rootWindow.setPopupMenuFactory(WindowMenuUtil.createWindowMenuFactory(abstractViewMap, true));
        }
        return rootWindow;
    }

    public static boolean isAncestor(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        return dockingWindow2 != null && (dockingWindow == dockingWindow2 || DockingUtil.isAncestor(dockingWindow, dockingWindow2.getWindowParent()));
    }

    public static void addWindow(DockingWindow dockingWindow, RootWindow rootWindow) {
        if (rootWindow == null || dockingWindow.getRootWindow() == rootWindow) {
            return;
        }
        if (dockingWindow.getRootWindow() == null) {
            dockingWindow.restore();
            if (dockingWindow.getRootWindow() == rootWindow) {
                return;
            }
        }
        InternalDockingUtil.addToRootWindow(dockingWindow, rootWindow);
    }

    public static TabWindow getTabWindowFor(DockingWindow dockingWindow) {
        return dockingWindow instanceof TabWindow ? (TabWindow)dockingWindow : (dockingWindow.getWindowParent() != null && dockingWindow.getWindowParent() instanceof TabWindow ? (TabWindow)dockingWindow.getWindowParent() : null);
    }

    public static FloatingWindow getFloatingWindowFor(DockingWindow dockingWindow) {
        if (dockingWindow == null) {
            return null;
        }
        if (!dockingWindow.isUndocked()) {
            return null;
        }
        while (dockingWindow != null && !(dockingWindow instanceof FloatingWindow)) {
            dockingWindow = dockingWindow.getWindowParent();
        }
        return (FloatingWindow)dockingWindow;
    }
}

