% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kemenyd.R
\name{kemenyd}
\alias{kemenyd}
\title{Kemeny distance}
\usage{
kemenyd(X, Y = NULL)
}
\arguments{
\item{X}{A N by M data matrix, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. If there is only X as input, the output is a square distance matrix}

\item{Y}{A row vector, or a n by M data matrix in which there are n judges and the same M objects as X to be judged.}
}
\value{
If there is anly X as input, d = square distance matrix. If there is also Y as input, d = matrix with N rows and n columns.
}
\description{
Compute the Kemeny distance of a data matrix containing preference rankings, or compute the kemeny distance between two (matrices containing) rankings.
}
\examples{
data(Idea)
RevIdea=6-Idea ##as 5 means "most associated", it is necessary compute the reverse 
#ranking of each rankings to have rank 1 = "most associated" and rank 5 = "least associated"
KD=kemenyd(RevIdea)
KD2=kemenyd(RevIdea[1:10,],RevIdea[55,])

}
\references{
Kemeny, J. G., & Snell, L. J. (1962). Preference ranking: an axiomatic approach. Mathematical models in the social sciences, 9-23.
}
\seealso{
\code{\link{Tau_X}} TauX rank correlation coefficient
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Kemeny}
\keyword{distance}
