% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tau_X.R
\name{Tau_X}
\alias{Tau_X}
\title{TauX (tau exstension) rank correlation coefficient}
\usage{
Tau_X(X, Y = NULL)
}
\arguments{
\item{X}{a M by N data matrix, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. If there is only X as input, the output is a square matrix containing the Tau_X rcc.}

\item{Y}{A row vector, or a n by M data matrix in which there are n judges and the same M objects as X to be judged.}
}
\value{
Tau_x rank correlation coefficient
}
\description{
Tau exstension is a new rank correlation coefficient defined by Emond and Mason (2002)
}
\examples{
data(BU)
RD=BU[,1:3]
Tau=Tau_X(RD)
Tau1_3=Tau_X(RD[1,],RD[3,])

}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient with application to the consensus ranking problem. Journal of Multi-Criteria Decision Analysis, 11(1), 17-28.
}
\seealso{
\code{\link{kemenyd}} Kemeny distance
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{TauX}
\keyword{coefficient}
\keyword{correlation}
\keyword{rank}
