/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.util.Hashtable;
import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;

public class Design {
    String title;
    String reference;
    String signature;
    public int t;
    public int s;
    public int p;
    String design;
    String result = null;
    String rName = null;
    String uniqueName = null;
    Hashtable<String, Double> ht = new Hashtable();

    public Design(String title, String rName) {
        this(title, rName, null);
    }

    public Design(String title, String rName, String reference) {
        this.title = title;
        this.rName = rName;
        this.reference = reference;
        this.saveDesign2R(true);
        this.t = RControl.getR().eval("length(levels(as.factor(" + this.uniqueName + ")))").asRInteger().getData()[0];
        int[] dim = RControl.getR().eval("dim(" + this.uniqueName + ")").asRInteger().getData();
        this.p = dim[0];
        this.s = dim[1];
        this.design = RControl.getR().eval("paste(capture.output(dput(" + this.uniqueName + ")), collapse=\"\")").asRChar().getData()[0];
    }

    public Design(String title, String rName, String reference, String signature, int t, int s, int p, String design) {
        this.title = title;
        this.rName = rName;
        this.reference = reference;
        this.signature = signature;
        this.t = t;
        this.s = s;
        this.p = p;
        this.design = design;
    }

    public String saveDesign2R(boolean useRName) {
        if (useRName) {
            this.uniqueName = "CODesign." + RControl.getR().eval("digest::digest(getDesign(" + this.rName + "))").asRChar().getData()[0];
            RControl.getR().eval(this.uniqueName + "<- getDesign(" + this.rName + ")");
        }
        RControl.getR().eval("attr(" + this.uniqueName + ",\"rName\") <- \"" + this.rName + "\"");
        if (this.reference != null) {
            RControl.getR().eval("attr(" + this.uniqueName + ",\"reference\") <- \"" + Design.escape(this.reference) + "\"");
        }
        RControl.getR().eval("attr(" + this.uniqueName + ",\"title\") <- \"" + Design.escape(this.title) + "\"");
        return this.uniqueName;
    }

    public static String escape(String s) {
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\"", "\\\\\"");
        return s;
    }

    public static void main(String[] args) {
        System.out.println("Test \" \\ ");
        System.out.println(Design.escape("Test \" \\ "));
    }

    public void setRName(String name) {
        this.rName = RControl.getR().eval("make.names(" + name + ")").asRChar().getData()[0];
    }

    public String getRSignature() {
        String rSignature = "p = " + this.p + ", n = " + this.s + ", t = " + this.t;
        return rSignature;
    }

    public String toString() {
        return this.title + " (" + this.signature + ")";
    }

    public String getRDesign() {
        return this.design;
    }

    public String getTextDesign() {
        if (this.result != null) {
            return this.result;
        }
        this.result = RControl.getR().eval("paste(capture.output(print(" + (this.uniqueName == null ? this.design : this.uniqueName) + ")), collapse=\"\\n\")").asRChar().getData()[0];
        return this.result;
    }

    public String getHTMLTable() {
        String result = RControl.getR().eval("Crossover:::getTable(" + (this.uniqueName == null ? this.design : this.uniqueName) + ", type=\"" + Configuration.getInstance().getProperty("outputF", "HTML") + "\"" + ", names=" + (Boolean.parseBoolean(Configuration.getInstance().getProperty("showNames", "true")) ? "TRUE" : "FALSE") + ")").asRChar().getData()[0];
        return result;
    }

    public boolean isEstimable(int model) {
        return RControl.getR().eval("Crossover:::estimable(" + this.uniqueName + ", " + this.t + ", " + model + ")").asRLogical().getData()[0];
    }

    public double getEff(int model, double param) {
        Double v;
        String key = "" + model;
        if (model == 3 || model == 2) {
            key = "" + model + "-" + param;
        }
        if ((v = this.ht.get(key)) == null) {
            v = RControl.getR().eval("getOffDiagMean(design.efficiency(" + this.getUniqueName() + ", model=" + model + ", model.param=list(ppp=" + param + ", placebos=" + param + "))$eff.trt.pair.adj)").asRNumeric().getData()[0];
            this.ht.put(key, v);
        }
        return v;
    }

    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.saveDesign2R(true);
        }
        return this.uniqueName;
    }
}

