/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.options;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.commons.widgets.buttons.OkApplyCancelButtonPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.MenuBarCrossover;
import org.mutoss.gui.options.GeneralPanel;
import org.mutoss.gui.options.OutputPanel;
import org.mutoss.gui.options.SetLookAndFeelException;

public class OptionsDialog
extends JDialog
implements ActionListener {
    private static final Log logger = LogFactory.getLog(OptionsDialog.class);
    private JTabbedPane tabbedPane;
    private GeneralPanel visualPanel;
    private OutputPanel outputPanel;
    private OkApplyCancelButtonPane bp;
    private Configuration conf;
    CrossoverGUI parent;

    public OptionsDialog(CrossoverGUI p) {
        super(p);
        this.parent = p;
        this.conf = Configuration.getInstance();
        this.setModal(true);
        this.setTitle("Options");
        this.setDefaultCloseOperation(2);
        this.makeComponents();
        this.doTheLayout();
        this.pack();
        this.setLocationRelativeTo(p);
        this.setVisible(true);
    }

    private void makeComponents() {
        this.tabbedPane = new JTabbedPane();
        this.visualPanel = new GeneralPanel(this.parent, this);
        this.outputPanel = new OutputPanel(this.parent, this);
        this.bp = new OkApplyCancelButtonPane();
    }

    private void doTheLayout() {
        this.tabbedPane.addTab("Output", this.outputPanel);
        this.tabbedPane.addTab("Visual", this.visualPanel);
        Container cp = this.getContentPane();
        cp.add(this.tabbedPane);
        cp = WidgetFactory.makeDialogPanelWithButtons((Container)cp, (HorizontalButtonPane)this.bp, (ActionListener)this);
        this.setContentPane(cp);
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("Got ActionCommand " + e.getActionCommand()));
        if (e.getActionCommand().equals("OK") || e.getActionCommand().equals("APPLY")) {
            try {
                this.visualPanel.setProperties();
                this.outputPanel.setProperties();
                if (e.getActionCommand().equals("OK")) {
                    this.dispose();
                }
                this.parent.repaint();
            }
            catch (SetLookAndFeelException exc) {
                ErrorHandler.getInstance().makeErrDialog(exc.getMessage(), (Object)exc);
            }
        }
        if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
        ((MenuBarCrossover)this.parent.getJMenuBar()).createExtraMenu();
    }
}

