% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{simulateCyclopsData}
\alias{simulateCyclopsData}
\title{Simulation Cyclops dataset}
\usage{
simulateCyclopsData(nstrata = 200, nrows = 10000, ncovars = 20,
  effectSizeSd = 1, zeroEffectSizeProp = 0.9, eCovarsPerRow = ncovars/100,
  model = "survival")
}
\arguments{
\item{nstrata}{Numeric: Number of strata}

\item{nrows}{Numeric: Number of observation rows}

\item{ncovars}{Numeric: Number of covariates}

\item{effectSizeSd}{Numeric: Standard derivation of the non-zero simulated regression coefficients}

\item{zeroEffectSizeProp}{Numeric: Expected proportion of zero effect size}

\item{eCovarsPerRow}{Number: Effective number of non-zero covariates per data row}

\item{model}{String: Simulation model. Choices are: \code{logistic}, \code{poisson} or \code{survival}}
}
\value{
A simulated data set
}
\description{
\code{simulateCyclopsData} generates a simulated large, sparse data set for use by \code{fitCyclopsSimulation}.
}
\examples{
#Generate some simulated data:
sim <- simulateCyclopsData(nstrata = 1, nrows = 1000, ncovars = 2, eCovarsPerRow = 0.5, 
                           model = "poisson")
cyclopsData <- convertToCyclopsData(sim$outcomes, sim$covariates, modelType = "pr", 
                                    addIntercept = TRUE)

#Define the prior and control objects to use cross-validation for finding the 
#optimal hyperparameter:
prior <- createPrior("laplace", exclude = 0, useCrossValidation = TRUE)
control <- createControl(cvType = "auto", noiseLevel = "quiet")

#Fit the model
fit <- fitCyclopsModel(cyclopsData,prior = prior, control = control)  

#Find out what the optimal hyperparameter was:
getHyperParameter(fit)

#Extract the current log-likelihood, and coefficients
logLik(fit)
coef(fit)

#We can only retrieve the confidence interval for unregularized coefficients:
confint(fit, c(0))
}
