% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{getCyclopsProfileLogLikelihood}
\alias{getCyclopsProfileLogLikelihood}
\title{Profile likelihood for Cyclops model parameters}
\usage{
getCyclopsProfileLogLikelihood(
  object,
  parm,
  x = NULL,
  bounds = NULL,
  tolerance = 0.001,
  initialGridSize = 10,
  maxResets = 10,
  includePenalty = TRUE,
  optimalWarmStart = TRUE
)
}
\arguments{
\item{object}{Fitted Cyclops model object}

\item{parm}{Specification of which parameter requires profiling,
either a vector of numbers or covariateId names}

\item{x}{Vector of values of the parameter}

\item{bounds}{Pair of values to bound adaptive profiling}

\item{tolerance}{Absolute tolerance allowed for adaptive profiling}

\item{initialGridSize}{Initial grid size for adaptive profiling}

\item{maxResets}{Maximum allowed number of recomputing the likelihood when coefficient drift is
detected.}

\item{includePenalty}{Logical: Include regularized covariate penalty in profile}

\item{optimalWarmStart}{Logical: Use optimal warm-starting when parallelizing evaluations}
}
\value{
A data frame containing the profile log likelihood. Returns NULL when the adaptive profiling fails
to converge.
}
\description{
\code{getCyclopsProfileLogLikelihood} evaluates the profile likelihood at a grid of parameter values.
}
