% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{make_assoc_stats}
\alias{make_assoc_stats}
\alias{concordant}
\alias{discordant}
\alias{ord.gamma}
\alias{ord.somers.d}
\alias{tau.b}
\alias{lambda}
\alias{phi}
\alias{V}
\alias{simtable}
\alias{simrho}
\alias{simtab}
\title{Make Categorical Association Statistics}
\usage{
make_assoc_stats(
  x,
  y,
  chisq = FALSE,
  phi = FALSE,
  cramersV = TRUE,
  lambda = FALSE,
  gamma = TRUE,
  d = FALSE,
  taub = TRUE,
  n = 1000,
  weight = NULL
)
}
\arguments{
\item{x}{The row-variable in a contingency table}

\item{y}{The column-variable in a contingency table}

\item{chisq}{Logical indicating whether the chi-squared statistic should be produced.}

\item{phi}{Logical indicating whether the phi statistic should be produced.}

\item{cramersV}{Logical indicating whether the Cramer's V statistic should be produced.}

\item{lambda}{Logical indicating whether the lambda statistic should be produced.}

\item{gamma}{Logical indicating whether the gamma statistic for ordinal data should be produced.}

\item{d}{Logical indicating whether Somer's D for ordinal data should be produced.}

\item{taub}{Logical indicating whether Kendall's Tau-b statistic should be produced.}

\item{n}{Number of iterations in the simulation.}

\item{weight}{Vector of weights used to generate the table.}
}
\value{
A matrix of statistics and p-values.
}
\description{
Makes several common measures of association for contingency tables.  The 
p-values are obtained through simulation.
}
