% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\docType{class}
\name{DBIConnection-class}
\alias{DBIConnection-class}
\alias{show,DBIConnection-method}
\title{DBIConnection class.}
\usage{
\S4method{show}{DBIConnection}(object)
}
\arguments{
\item{object}{Object to display}
}
\description{
This virtual class encapsulates the connection to a DBMS, and it provides
access to dynamic queries, result sets, DBMS session management
(transactions), etc.
}
\section{Implementation note}{

Individual drivers are free to implement single or multiple simultaneous
connections.
}
\examples{
\dontrun{
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbDisconnect(con)

con <- dbConnect(RPostgreSQL::PostgreSQL(), "username", "passsword")
dbDisconnect(con)
}
}
\seealso{
Other DBI classes: \code{\link{DBIDriver-class}},
  \code{\link{DBIObject-class}},
  \code{\link{DBIResult-class}}
}

