#' @name dichotomousItemParameters
#' @title Sets of focal and reference item parameters from Wright (2011).
#' @description This data set contains the item parameters found in Wright, K. (2011). Improvements for Differential
#' Funtioning of Items and Tests (DFIT): Investigating the addition of reporting an effect size measure and power
#' Unpublished doctoral dissertation). Georgia State University, USA.
#' @docType data
#' @usage data(dichotomousItemParameters)
#' @format a list with 'focal' and 'reference' elements. Each is a \code{matrix} 1 row per item by 3 columns: item discrimination, difficulty and guessing parameters.
#' @source This data set contains the item parameters based on those found in Wright, K. (2011). Improvements for Differential
#' Funtioning of Items and Tests (DFIT): Investigating the addition of reporting an effect size measure and power
#' (Unpublished doctoral dissertation). Georgia State University, USA.
NULL

#' @name polytomousItemParameters
#' @title Sets of focal and reference item parameters from Raju et al. (2009)
#' @description This data set contains the item parameters found in Raju, N., Fortmann-Johnson, K., Kim, W., Morris, S.,
#' Nering, M. & Oshima, T. (2009). The item parameter replication method for detecting differential functioning in the
#' polytomous DFIT framework. Applied psychological measurement, 33(2), 133--147.
#' @docType data
#' @usage data(polytomousItemParameters)
#' @format a list with 'focal' and 'reference' elements. Each is a \code{matrix} 1 row per item by 5 columns: item discrimination, four item step parameters. 
#' @source This data set contains the item parameters based on those found in  Raju, N., Fortmann-Johnson, K., Kim, W., Morris, S.,
#' Nering, M. & Oshima, T. (2009). The item parameter replication method for detecting differential functioning in the
#' polytomous DFIT framework. Applied psychological measurement, 33(2), 133--147.
NULL

