% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMSErobust.r
\name{runMSErobust}
\alias{runMSErobust}
\title{Run a Management Strategy Evaluation}
\usage{
runMSErobust(OM = DLMtool::testOM, MPs = c("AvC", "DCAC", "FMSYref", "curE",
  "matlenlim"), nsim = 256, proyears = 50, interval = 4, pstar = 0.5,
  maxF = 0.8, timelimit = 1, reps = 1, CheckMPs = FALSE, Hist = FALSE,
  ntrials = 50, fracD = 0.05, CalcBlow = FALSE, HZN = 2, Bfrac = 0.5,
  maxsims = 64, name = NULL, unique = FALSE, maxCrash = 10,
  saveMSE = TRUE, savePack = FALSE)
}
\arguments{
\item{OM}{An operating model object (class OM)}

\item{MPs}{A vector of methods (character string) of class Output or
Input.}

\item{nsim}{Number of simulations}

\item{proyears}{Number of projected years}

\item{interval}{The assessment interval - how often would you like to update
the management system?}

\item{pstar}{The percentile of the sample of the management recommendation
for each method}

\item{maxF}{Maximum instantaneous fishing mortality rate that may be
simulated for any given age class}

\item{timelimit}{Maximum time taken for a method to carry out 10 reps
(methods are ignored that take longer)}

\item{reps}{Number of samples of the management recommendation for each
method. Note that when this is set to 1, the mean value of the data inputs
is used.}

\item{CheckMPs}{Logical to indicate if Can function should be used to check
if MPs can be run.}

\item{Hist}{Should model stop after historical simulations? Returns a list 
containing all historical data}

\item{ntrials}{Maximum of times depletion and recruitment deviations are 
resampled to optimize for depletion. After this the model stops if more than 
percent of simulations are not close to the required depletion}

\item{fracD}{maximum allowed proportion of simulations where depletion is not 
close to sampled depletion from OM before model stops with error}

\item{CalcBlow}{Should low biomass be calculated where this is the spawning
biomass at which it takes HZN mean generation times of zero fishing to reach}

\item{HZN}{The number of mean generation times required to reach Bfrac SSBMSY
in the Blow calculation}

\item{Bfrac}{fraction of SSBMSY}

\item{maxsims}{Maximum number of simulations per packet}

\item{name}{Character string for name of saved MSE packets (if \code{savePack=TRUE}) 
and final MSE object. If none provided, it uses the first five letters from the \code{OM} name}

\item{unique}{Logical. Should the name be unique? Current date and time appended to name.}

\item{maxCrash}{Maximum number of consecutive crashes before the MSE stops}

\item{saveMSE}{Logical to indicate if final MSE object should be saved to current 
working directory (this is probably a good idea)}

\item{savePack}{Logical to indicate if packets should be save to current working directory}
}
\value{
An object of class MSE
}
\description{
Run a Management Strategy Evaluation and save out the results to a Rdata
file.  To increase speed and efficiency, particulary for runs with a large
number simulations (\code{nsim}), the simulations are split into a number of
packets.  The functions loops over the packets and combines the output into
a single MSE object. If the MSE model crashes during a run, the MSE is run
again until it is successfully completed. The MSE is stopped if the number
of consecutive crashes exceeds \code{maxCrash}.  There is an ption to save
the packets as Rdata files to the current working directory (default is
FALSE). By default, the functions saves the completed MSE object as a Rdata
file (to the current working directory).
}
\author{
A. Hordyk and T. Carruthers
}
