% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data2OMfunctions.r
\name{Growth2OM}
\alias{Growth2OM}
\title{Generate bootstrapped estimates of von Bertalanffy growth parameters from length-at-age data}
\usage{
Growth2OM(data = NULL, OM = NULL, nsim = 48, seed = 101,
  plot = TRUE, msg = TRUE)
}
\arguments{
\item{data}{A data.frame with columns names 'Age' and 'Length'}

\item{OM}{Optional. Object of class \code{OM}. Function will return OM with \code{cpars}
slot populated if an OM is provided, otherwise it returns a data.frame}

\item{nsim}{Optional numeric. If an OM is not provided, nsim is used.}

\item{seed}{Optional numierc. If an OM is not provided, seed is used in \code{set.seed}.}

\item{plot}{Logical. Plot the data and model fits?}

\item{msg}{Logical. Display messages?}
}
\value{
An OM with cpars slot populated with Linf, K, t0 and LenCV values,
or a data.frame.
}
\description{
The von Bertalanffy model is fitted to length-at-age data and bootstrapped to
provide either \code{OM@nsim} or \code{nsim} estimates of Linf, K, and t0 parameters.
LenCV is also estimated from mean growth curve and the observed length-at-age data.
}
\details{
The function either returns an OM with the cpars slot updated with estimated values,
or a data.frame with the estimated values.
}
\examples{
# Simple model to generate length-at-age data
OM <- DLMtool::testOM 
OM@nsim <- 2
Hist <- runMSE(OM, Hist=TRUE)
N <- Hist$AtAge$N[1,,1] * Hist$AtAge$Sl_age[1,,1]
meanL <- Hist$AtAge$Len_age[1,,1]
sdL <- Hist$AtAge$Len_age[1,,1] * 0.1
nsamp <- ceiling(N/sum(N) * 1000)
Length <- unlist(sapply(1:length(meanL), function(i) rnorm(nsamp[i], meanL[i], sdL[i])))
Ages <- rep(1:length(N), nsamp)
data <- data.frame(Age=Ages, Length=Length)

# Return an OM with cpars populated
OM@nsim <- 48
newOM <- Growth2OM(data, OM)

# Return a data.frame
estPars <- Growth2OM(data)
 
}
