% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fease_Functions.R
\name{Fease}
\alias{Fease}
\title{MP feasibility diagnostic}
\usage{
Fease(Data = NULL, TAC = TRUE, TAE = TRUE, SL = TRUE, Spatial = TRUE,
  names.only = TRUE, msg = TRUE, include.ref = FALSE)
}
\arguments{
\item{Data}{An object of class 'Data'. Optional. If Data object is included, the returned MPs are both feasible (in terms of management)
and possible (sufficient data to run MP)}

\item{TAC}{Logical. Are catch limits feasible for this fishery?}

\item{TAE}{Logical. Are effort controls feasible for this fishery?}

\item{SL}{Logical. Are size-selectivity regulations (either gear changes or size-retention regulations) feasible for this fishery?}

\item{Spatial}{Logical. Are spatial closures feasible for this fishery?}

\item{names.only}{Logical. Should only the names of the feasible MPs be returned (default)? If FALSE, a data frame with MP name, and two columns
of logical values: Can (possible given data) and Fease (feasible given management constraints) is returned}

\item{msg}{Logical. Should messages be printed to the console?}

\item{include.ref}{Logical. Should reference MPs (e.g. FMSYref) be included as feasible methods? Default is FALSE}
}
\value{
Either a vector of MP names that are feasible for the fishery (default) or a 3 column data frame (\code{names.only=FALSE}).
}
\description{
What MPs may be run (best case scenario) for various data-availability
scenarios and management constraints?
}
\examples{
\dontrun{
Fease(TAC=FALSE)
Fease(SL=FALSE, Spatial=FALSE)
Fease(Atlantic_mackerel, TAE=FALSE, names.only=FALSE)
}
}
\author{
T. Carruthers & A. Hordyk
}
