% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Input.R
\name{LtargetE1}
\alias{LtargetE1}
\alias{LtargetE4}
\title{Length Target TAE MP}
\usage{
LtargetE1(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xL = 1.05)

LtargetE4(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xL = 1.15)
}
\arguments{
\item{x}{A position in a data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which to calculate mean length}

\item{xL}{Parameter controlling the magnitude of the target mean length of
catches relative to average length in catches.}
}
\value{
An object of class \code{\link[=Rec-class]{Rec}} with the TAE slot(s) populated
}
\description{
A management procedure that incrementally adjusts the TAE to reach
a target mean length in catches.
}
\details{
Four target length MPs proposed by Geromont and Butterworth 2014.
Tested by Carruthers et al. 2015.

The TAE is calculated as:

If \eqn{L_\textrm{recent} \geq L_0}:
\deqn{\textrm{TAE} = 0.5 \textrm{TAE}^* \left[1+\left(\frac{L_\textrm{recent}-L_0}{L_\textrm{target}-L_0}\right)\right]  }

else:
\deqn{\textrm{TAE} = 0.5 \textrm{TAE}^* \left[\frac{L_\textrm{recent}}{L_0}^2\right] }

where \eqn{\textrm{TAE}^*} is the effort in the previous year,
\eqn{L_\textrm{recent}} is mean length in last \code{yrmsth} years, \eqn{L_0} is (except for \code{L95target}) 0.9 average catch in the last
2 x \code{yrsmth} historical (pre-projection years) (\eqn{L_\textrm{ave}}), and \eqn{L_\textrm{target}} is
(except for \code{L95target}) \code{xL} \eqn{L_\textrm{ave}}.
}
\section{Functions}{
\itemize{
\item \code{LtargetE1}: The least biologically precautionary TAE-based MP.

\item \code{LtargetE4}: The \code{xL} argument is increased to 1.15.
}}

\section{Required Data}{

See \linkS4class{Data} for information on the \code{Data} object \cr


\code{LtargetE1}: LHYear, ML, MPeff, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.github.io/DLMtool/reference/LtargetE1.html}{Online Documentation} for correctly rendered equations
}

\examples{
LtargetE1(1, Data=DLMtool::SimulatedData, plot=TRUE)
LtargetE4(1, Data=DLMtool::SimulatedData, plot=TRUE)
}
\references{
Carruthers et al. 2015. Performance evaluation of simple
management procedures. ICES J. Mar Sci. 73, 464-482.

Geromont, H.F., Butterworth, D.S. 2014. Generic management procedures for
data-poor fisheries; forecasting with few data. ICES J. Mar. Sci.
doi:10.1093/icesjms/fst232
}
\seealso{
Other Length target MPs: \code{\link{Lratio_BHI}},
  \code{\link{Ltarget1}}
}
\author{
T. Carruthers
}
\concept{Length target MPs}
