% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_init_doc.R
\name{OMdoc}
\alias{OMdoc}
\title{Generate OM Documentation Report}
\usage{
OMdoc(
  OM = NULL,
  rmd.source = NULL,
  overwrite = FALSE,
  out.file = NULL,
  inc.plot = TRUE,
  render = TRUE,
  output = "html_document",
  openFile = TRUE,
  quiet = FALSE,
  dir = NULL,
  ...
)
}
\arguments{
\item{OM}{An object of class 'OM' or the name of an OM xlsx file}

\item{rmd.source}{Optional. Name of the source.rmd file corresponding to the 'OM'. Default assumption
is that the file is 'OM@Name.Rmd'}

\item{overwrite}{Logical. Should existing files be overwritten?}

\item{out.file}{Optional. Character. Name of the output file. Default is the same as the text file.}

\item{inc.plot}{Logical. Should the plots be included?}

\item{render}{Logical. Should the document be compiled? May be useful to turn off if
there are problems with compililing the Rmd file.}

\item{output}{Character. Output file type. Default is 'html_document'. 'pdf_document' is available
but may require additional software and have some formatting issues.}

\item{openFile}{Logical. Should the compiled file be opened in web browser?}

\item{quiet}{TRUE to supress printing of the pandoc command line.}

\item{dir}{Optional file path to read the xlsx and rmd files. Default is \code{getwd()}}

\item{...}{Optional additional named arguments provided to \code{runMSE}}
}
\value{
Creates a Rmarkdown file and compiles a HTML report file in the working directory.
}
\description{
Generate OM Documentation Report
}
\note{
See relevant section of the \href{https://dlmtool.github.io/DLMtool/userguide/creating-a-new-operating-model.html#populate-and-document-om}{DLMtool User Guide} for more information.
}
\examples{
\dontrun{
OMinit('myOM', Stock='Herring', Fleet='Generic_Fleet', Obs='Generic_Obs',
Imp='Perfect_Imp', overwrite=TRUE)
myOM <- XL2OM('myOM.xlsx')
OMdoc(myOM)
}
}
\author{
A. Hordyk
}
