#' @title data.for.distance
#' @description Formats the data generated by create.survey.results into
#' a form suitable for import into Distance
#' @param object an object of class Survey.Results generated by create.survey.results
#' @param file path and filename if the user would like the results saves to csv file. Should contain the .csv file extension.
#' @export
#' @author L Marshall
data.for.distance <- function(object, file = NULL){
  # get data tables
  ddf.dat <- object@ddf.data@ddf.dat
  obs.table <- object@obs.table@obs.table
  sample.table <- object@sample.table@sample.table
  region.table <- object@region.table@region.table
  # merge data tables
  temp <- merge(obs.table, ddf.dat, by = "object")
  temp2 <- merge(sample.table, temp, by = c("Sample.Label", "Region.Label"))
  dist.data <- merge(region.table, temp2, by = c("Region.Label"))
  # order by transect ID
  index <- order(dist.data$Sample.Label)
  dist.data <- dist.data[index,]
  # Only keep certain columns (remove duplicates)
  col.index <- which(names(dist.data) %in% c("Region.Label", "Area", "Sample.Label", "Effort", "length", "distance"))
  dist.data <- dist.data[,col.index]
  # Save if requested or return
  if(is.null(file)){
    return(dist.data)  
  }else{
    write.csv(dist.data, file = file, row.names = FALSE)
    invisible(dist.data)
  }
}