% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlation.r
\name{plot_correlation}
\alias{plot_correlation}
\title{Create correlation heatmap for discrete features}
\usage{
plot_correlation(
  data,
  type = c("all", "discrete", "continuous"),
  maxcat = 20L,
  cor_args = list(),
  geom_text_args = list(),
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(legend.position = "bottom", axis.text.x = element_text(angle = 90))
)
}
\arguments{
\item{data}{input data}

\item{type}{column type to be included in correlation calculation. "all" for all columns, "discrete" for discrete features, "continuous" for continuous features.}

\item{maxcat}{maximum categories allowed for each discrete feature. The default is 20.}

\item{cor_args}{a list of other arguments to \link{cor}}

\item{geom_text_args}{a list of other arguments to \link{geom_text}}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}
}
\value{
invisibly return the ggplot object
}
\description{
This function creates a correlation heatmap for all discrete categories.
}
\details{
For discrete features, the function first dummifies all categories, then calculates the correlation matrix (see \link{cor}) and plots it.
}
\examples{
plot_correlation(iris)
plot_correlation(iris, type = "c")
plot_correlation(airquality, cor_args = list("use" = "pairwise.complete.obs"))
}
\keyword{plot_correlation}
