/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.Template;

public class TemplateEditView
extends ElementView {
    Template model;
    private JScrollPane scroller;
    private JPanel panel;
    Vector optionPanels = new Vector();

    public TemplateEditView(Template template) {
        this.initGui();
        this.setModel(template);
    }

    public ElementModel getModel() {
        return this.model;
    }

    public void setModel(ElementModel elementModel) {
        this.model = (Template)elementModel;
        this.updatePanel();
    }

    public void updateModel() {
        for (int i = 0; i < this.optionPanels.size(); ++i) {
            ((MaskOptions)this.optionPanels.get(i)).updateModel();
        }
    }

    public void initGui() {
        this.setLayout(new BorderLayout());
        this.scroller = new JScrollPane();
        this.scroller.setHorizontalScrollBarPolicy(31);
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.scroller.setBorder(border);
        this.add(this.scroller);
        this.panel = new JPanel();
        this.scroller.setViewportView(this.panel);
    }

    public void updatePanel() {
        this.panel.removeAll();
        BoxLayout boxLayout = new BoxLayout(this.panel, 1);
        this.panel.setLayout(boxLayout);
        Template.MaskingAes[] maskingAesArray = this.model.mAess;
        for (int i = 0; i < maskingAesArray.length; ++i) {
            MaskOptions maskOptions = new MaskOptions(i, true);
            this.panel.add(maskOptions);
            this.optionPanels.add(maskOptions);
        }
        Template.MaskingParam[] maskingParamArray = this.model.mParams;
        for (int i = 0; i < maskingParamArray.length; ++i) {
            MaskOptions maskOptions = new MaskOptions(i, false);
            this.panel.add(maskOptions);
            this.optionPanels.add(maskOptions);
        }
        this.panel.validate();
        this.panel.repaint();
    }

    class MaskOptions
    extends JPanel {
        public JCheckBox show = new JCheckBox("show");
        public JLabel label = new JLabel();
        public JTextField name = new JTextField();
        public int index;
        public boolean isAes = false;

        public MaskOptions(int n, boolean bl) {
            GridLayout gridLayout = new GridLayout(0, 3);
            this.setLayout(gridLayout);
            this.add(this.label);
            this.add(this.show);
            this.add(this.name);
            this.setPreferredSize(new Dimension(241, 37));
            this.setMaximumSize(new Dimension(1000, 37));
            this.setModel(n, bl);
        }

        public void setModel(int n, boolean bl) {
            this.index = n;
            this.isAes = bl;
            if (bl) {
                Template.MaskingAes maskingAes = TemplateEditView.this.model.mAess[this.index];
                this.label.setText(maskingAes.name);
                this.show.setSelected(maskingAes.show);
                this.name.setText(maskingAes.aes.title);
            } else {
                Template.MaskingParam maskingParam = TemplateEditView.this.model.mParams[this.index];
                this.label.setText(maskingParam.paramName);
                this.show.setSelected(maskingParam.show);
                this.name.setText(maskingParam.param.getTitle());
            }
        }

        public void updateModel() {
            if (this.isAes) {
                Template.MaskingAes maskingAes = TemplateEditView.this.model.mAess[this.index];
                maskingAes.show = this.show.isSelected();
                maskingAes.aes.title = this.name.getText();
            } else {
                Template.MaskingParam maskingParam = TemplateEditView.this.model.mParams[this.index];
                maskingParam.show = this.show.isSelected();
                maskingParam.param.setTitle(this.name.getText());
            }
        }
    }
}

