/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.RObjectChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataViewerTab;
import org.rosuda.deducer.toolkit.HelpButton;

public class CorpusViewerPanel
extends DataViewerTab {
    JTextArea documentTextArea;
    JTable documentTable;
    RObjectChooser corpusSelector;
    JFormattedTextField goToField;
    boolean showCorpusSelector = false;
    private JLabel corpusNameLabel;
    private static final String HELP_URL = "index.php?n=Main.TextViewCorpus";

    public CorpusViewerPanel(boolean bl) {
        this.showCorpusSelector = bl;
        this.corpusNameLabel = new JLabel("");
        this.corpusSelector = new RObjectChooser((Component)((Object)this));
        this.corpusSelector.setClassFilter("Corpus");
        this.corpusSelector.refreshObjects();
        this.corpusSelector.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CorpusViewerPanel.this.corpusSelector.getSelectedObject();
                if (string != null) {
                    CorpusViewerPanel.this.setData(string);
                }
            }
        });
        this.documentTextArea = new JTextArea();
        this.documentTextArea.setLineWrap(true);
        this.documentTextArea.setWrapStyleWord(true);
        this.documentTextArea.setEditable(false);
        this.goToField = new JFormattedTextField((Object)5);
        this.goToField.setText("0");
        this.goToField.setColumns(4);
        this.goToField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = CorpusViewerPanel.this.intFromString(CorpusViewerPanel.this.goToField.getText(), 1, CorpusViewerPanel.this.documentTable.getRowCount());
                if (n != null) {
                    CorpusViewerPanel.this.documentTable.setRowSelectionInterval(n - 1, n - 1);
                    CorpusViewerPanel.this.documentTable.scrollRectToVisible(new Rectangle(CorpusViewerPanel.this.documentTable.getCellRect(n - 1, 0, true)));
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        Object[] objectArray = new String[]{"Doc #", "Text"};
        Object[][] objectArray2 = new Object[][]{};
        this.documentTable = new JTable(objectArray2, objectArray){
            {
                this.showHorizontalLines = true;
                this.showVerticalLines = true;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.setupTable();
        this.documentTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getMinSelectionIndex();
                if (n > -1) {
                    CorpusViewerPanel.this.documentTextArea.setText((String)CorpusViewerPanel.this.documentTable.getModel().getValueAt(n, 1));
                    CorpusViewerPanel.this.goToField.setText("" + (n + 1));
                }
            }
        });
        this.assembleGui();
        if (this.corpusSelector.getObjectCount() > 0) {
            this.corpusSelector.getComboBox().setSelectedIndex(0);
        }
    }

    private void setupTable() {
        this.documentTable.setShowVerticalLines(false);
        this.documentTable.setGridColor(Color.LIGHT_GRAY);
        this.documentTable.setRowHeight(20);
        this.documentTable.setAutoResizeMode(1);
        this.documentTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.documentTable.getColumnModel().getColumn(0).setMinWidth(50);
        this.documentTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.documentTable.getTableHeader().setResizingAllowed(false);
        this.documentTable.getTableHeader().setReorderingAllowed(false);
        this.documentTable.setSelectionMode(0);
        this.documentTable.setRowSelectionAllowed(true);
        this.documentTable.setColumnSelectionAllowed(false);
    }

    private Integer intFromString(String string, int n, int n2) {
        try {
            int n3 = Integer.parseInt(string);
            if (n3 >= n && n3 <= n2) {
                return new Integer(n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private GridBagConstraints getTopLevelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        return gridBagConstraints;
    }

    private void assembleGui() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel("Corpus:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        if (this.showCorpusSelector) {
            jPanel2.add((Component)this.corpusSelector, gridBagConstraints);
        } else {
            jPanel2.add((Component)this.corpusNameLabel, gridBagConstraints);
        }
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)new HelpButton(HELP_URL), "East");
        jPanel3.add((Component)new JLabel("Go To: "), "West");
        jPanel3.add((Component)this.goToField, "Center");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JSplitPane jSplitPane = new JSplitPane();
        JScrollPane jScrollPane = new JScrollPane(this.documentTable);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        JScrollPane jScrollPane2 = new JScrollPane(this.documentTextArea);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel("Document Text:"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel4.add((Component)jScrollPane2, gridBagConstraints);
        jScrollPane2.setPreferredSize(new Dimension(250, 200));
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(jPanel4);
        jSplitPane.setBorder(new LineBorder(Color.BLACK, 0));
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jSplitPane, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        CorpusViewerPanel corpusViewerPanel = new CorpusViewerPanel(false);
        jFrame.add((Component)((Object)corpusViewerPanel));
        jFrame.setVisible(true);
    }

    public void setData(String string) {
        final String string2 = string;
        new Thread(new Runnable(){

            public void run() {
                try {
                    final int n = Deducer.timedEval((String)String.format("length(%s)", string2)).asInteger();
                    Object[][] objectArray = new Object[n][2];
                    final String[] stringArray = new String[]{"Doc #", "Text"};
                    for (int i = 1; i <= n; ++i) {
                        String string = Deducer.timedEval((String)("paste(" + string2 + "[[" + i + "]],sep='',collapse='\n')")).asString();
                        objectArray[i - 1][0] = i;
                        objectArray[i - 1][1] = string;
                    }
                    final Object[][] objectArray2 = objectArray;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CorpusViewerPanel.this.corpusNameLabel.setText(string2);
                            CorpusViewerPanel.this.documentTable.setModel(new DefaultTableModel(objectArray2, stringArray));
                            CorpusViewerPanel.this.setupTable();
                            if (n > 0) {
                                CorpusViewerPanel.this.documentTable.setRowSelectionInterval(0, 0);
                            }
                        }
                    });
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    rEXPMismatchException.printStackTrace();
                }
            }
        }).start();
    }

    public void refresh() {
    }

    public JMenuBar generateMenuBar() {
        return new JMenuBar();
    }

    public void cleanUp() {
    }
}

