% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_series.R
\name{create_series}
\alias{create_series}
\title{Create a graph series object}
\usage{
create_series(graph = NULL, series_name = NULL,
  series_type = "sequential", series_scripts = NULL)
}
\arguments{
\item{graph}{a graph object to add to the new graph series object.}

\item{series_name}{an optional name to ascribe to the series.}

\item{series_type}{either a \code{sequential} type (the default) or a
\code{temporal} type (which requires date-time strings and time zone codes
to be supplied).}

\item{series_scripts}{a vector of R scripts or paths to R scripts.}
}
\value{
a graph series object of type \code{dgr_graph_1D}.
}
\description{
Create a graph series object for storage of multiple graphs
across a sequential or temporal one-dimensional array.
}
\examples{
\dontrun{
# Create three graphs (using \\code{magrittr} pipes)
# and create a graph series using those graphs
library(magrittr)

graph_1 <- create_graph() \%>\%
  add_node("a") \%>\% add_node("b") \%>\% add_node("c") \%>\%
  add_edge("a", "c") \%>\% add_edge("a", "b") \%>\% add_edge("b", "c")

graph_2 <- graph_1 \%>\%
  add_node("d") \%>\% add_edge("d", "c")

graph_3 <- graph_2 \%>\%
  add_node("e") \%>\% add_edge("e", "b")

# Create an empty graph series
series <- create_series(series_type = "sequential")

# Add graphs to the graph series
series <- graph_1 \%>>\% add_to_series(series)
series <- graph_2 \%>>\% add_to_series(series)
series <- graph_3 \%>>\% add_to_series(series)
}
}

