% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_count.R
\name{edge_count}
\alias{edge_count}
\title{Get count of all edges or edges with distinct
relationship types}
\usage{
edge_count(graph, rel = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{rel}{either a logical value, where \code{TRUE}
provides a named vector of edge count by type and
\code{FALSE} (the default) provides a total count of
edges, or, a string corresponding to one or more
edge relationship types.}
}
\value{
a numeric vector of single length.
}
\description{
From a graph object of class
\code{dgr_graph}, get a count of edges in the graph
and optionally obtain a count of edges by their
relationship type.
}
\examples{
# Set a seed
set.seed(23)

# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 26,
    label = TRUE,
    type = c(rep("a", 7),
             rep("b", 9),
             rep("c", 8),
             rep("d", 2)))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = sample(1:26, replace = TRUE),
    to = sample(1:26, replace = TRUE),
    rel = c(rep("rel_a", 7),
            rep("rel_b", 9),
            rep("rel_c", 8),
            rep("rel_d", 2)))

# Create a graph using the ndf and edf
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Get a total count of edges in the graph
edge_count(graph, rel = FALSE)
#> [1] 26

# Get a count of edges that have the
# relationship of `rel_a`
edge_count(graph, rel = "rel_a")
#> [1] 7

# Get a count of edges with relationships
# `rel_a` and `rel_b`
edge_count(graph, rel = c("rel_a", "rel_b"))
#> [1] 16
}
