% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_node_attrs.R
\name{copy_node_attrs}
\alias{copy_node_attrs}
\title{Copy a node attribute column and set the name}
\usage{
copy_node_attrs(graph, node_attr_from, node_attr_to)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr_from}{The name of the node attribute column from which values
will be copied.}

\item{node_attr_to}{The name of the new node attribute column to which the
copied values will be placed.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data frame (ndf), copy the contents an
existing node attribute and create a distinct node attribute within the ndf
with a different attribute name.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 10,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = shape,
    values = "circle") \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 5,
      sd = 1) \%>\% round(1))

# Get the graph's internal
# ndf to show which node
# attributes are available
graph \%>\% get_node_df()

# Make a copy the `value`
# node attribute as the
# `width` node attribute
graph <-
  graph \%>\%
  copy_node_attrs(
    node_attr_from = value,
    node_attr_to = size)

# Get the graph's internal
# ndf to show that the node
# attribute had been copied
graph \%>\% get_node_df()

}
