% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_periphery.R
\name{get_periphery}
\alias{get_periphery}
\title{Get nodes that form the graph periphery}
\usage{
get_periphery(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A vector of node IDs.
}
\description{
Get those nodes that are part of the graph periphery (i.e., have the maximum
eccentricity in the graph).
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function and
# get the nodes in the graph periphery
create_graph() \%>\%
  add_gnm_graph(
    n = 28,
    m = 35,
    set_seed = 23) \%>\%
  get_periphery()

}
