% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HillEstimator.R
\name{HillEstimator}
\alias{HillEstimator}
\title{Hill Estimator}
\usage{
HillEstimator(Ra, tail.size)
}
\arguments{
\item{Ra}{Data set}

\item{tail.size}{Number of observations to be used to estimate the Hill
estimator.}
}
\value{
Estimated value of Hill Estimator
}
\description{
Estimates the value of the Hill Estimator for a given specified data set and
chosen tail size. Notes: 1) We estimate Hill Estimator by looking at the
upper tail. 2) If the specified tail size is such that any included
observations are negative, the tail is truncated at the point before
observations become negative. 3) The tail size must be a scalar.
}
\examples{
# Estimates Hill Estimator of
   Ra <- rnorm(15)
   HillEstimator(Ra, 10)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

