% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.sortalleles.R
\name{eco.sortalleles}
\alias{eco.sortalleles}
\title{Sorting alleles of an ecogen genetic data frame.}
\usage{
eco.sortalleles(eco, ndig)
}
\arguments{
\item{eco}{ecogen object.}

\item{ndig}{Number of digits coding each allele (e.g. 2: xx, or 3: xxx).}
}
\description{
This program returns a data fame with the alleles
of each individual \emph{i} and each loci \emph{j} in ascending order.
For example, a locus of type 51 is returned as 15.
}
\examples{
\dontrun{

data(eco.test)
eco <- ecogen(XY = coordinates, P = phenotype, G = genotype,
E = environment, S = as.data.frame(structure), missing = 0)
eco$G
eco <- eco.sortalleles(eco, 1)
eco$G

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

