% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.6OF6.converters.R
\name{spagedi2ecogen}
\alias{spagedi2ecogen}
\title{Importing a SPAGeDi file, via conversion to ecogen}
\usage{
spagedi2ecogen(infile, sep = "", missCode = NULL, type = c("codominant",
  "dominant"), ...)
}
\arguments{
\item{infile}{Path to the SPAGeDi file.}

\item{sep}{Character separating alleles (codominant data). 
Default option is no character separating alleles.}

\item{missCode}{characters to represent missing genotypes in codominant markers. 
If NULL, is computed as "0" times the numer of characters coding alleles.}

\item{type}{Marker type: "codominant" or "dominant".}

\item{...}{additional arguments passed to \code{ecogen}}
}
\description{
This function converts a SPAGeDi file into a ecogen object
}
\examples{

\dontrun{

data(eco.test)
ecogen2spagedi(eco, dir = "", pop = "pop", ndig = 1,int=2, smax=6, outName="infile.spagedi.txt")
spagedi2ecogen("infile.spagedi.txt", sep = "")
}


}
\author{
Leandro Roser \email{learoser@gmail.com}
}
