\name{triplets}
\alias{triplets}
\title{
calculate ratings from sequence of rating events, allowing for more than two stimuli
}
\description{
calculate ratings from sequence of rating events, allowing for more than two stimuli
}
\usage{
triplets(xdata, winner, runs=2, startvalue=0, k=100, progressbar=TRUE, mode="avg")
}
\arguments{
  \item{xdata}{
  data.frame or matrix with stimulus IDs, each row representing one trial, needs to contain at least two columns
}
  \item{winner}{
  numeric vector of the same length as \code{nrow(xdata)}, indicating which column in \code{xdata} is the winner/preferred stimulus
}
  \item{runs}{
  numeric, the number of times the data set should be randomized
}
  \item{startvalue}{
  numeric, initial value of ratings, by default \code{0}.
}
  \item{k}{
  numeric, value of \emph{k}-constant
}
  \item{progressbar}{
  logical, by default \code{TRUE}. Should a progress bar be displayed
}
  \item{mode}{
  character, either \code{"avg"} (default) or \code{"seq"}, see Details section
}
}
\details{
The \code{mode="avg"} option considers the losers of the trial as one individual/stimulus, whose rating is averaged. This reflects one rating step for each trial (as for \code{elochoice()}).

The \code{mode="seq"} option runs a sequence of interactions \emph{within} a trial, i.e. one rating step for each of the loosing stimuli. E.g. if you have three stimuli, that would be two rating steps. With four stimuli, we would have three steps, etc.

Because of the larger number of rating events with \code{mode="seq"}, the range of Elo-ratings will be larger as compared to \code{mode="avg"}. The average values will be the same for both though (start value). See examples...

Also note that this is an experimental function that has not yet been tested thoroughly! In addition, this function calculates winning probabilities in a slightly different way as compared to \code{elochoice}, i.e. based on normal probabilities (see \code{\link{elochoice}}).
}
\value{
a matrix with ratings
}
\author{
Christof Neumann
}
\examples{
\dontrun{
data(physical)
y <- round(triplets(physical[,2:3], winner=rep(1,nrow(physical)), runs = 1))
x <- ratings(elochoice(physical$Winner, physical$Loser, runs = 1), show = "all", drawplot = FALSE)
x <- x[order(names(x))]
plot(x, y)

xdata <- as.matrix(t(sapply(1:500, function(x)sample(letters[1:8], 3))))
xdata <- t(apply(xdata, 1, sort))
winner <- sample(1:3, nrow(xdata), TRUE, prob = c(4,0.8, 0.1))

x <- triplets(xdata, winner, runs=20, mode="avg")
y <- triplets(xdata, winner, runs=20, mode="seq")

# note different ranges along the axes
plot(colMeans(x), colMeans(y))
range(colMeans(x))
range(colMeans(y))}
}
