% Generated by roxygen2 (4.0.2): do not edit by hand
\name{netdx}
\alias{netdx}
\title{Dynamic Network Model Diagnostics}
\usage{
netdx(x, nsims = 1, nsteps, nwstats.formula = "formation", set.control.ergm,
  set.control.stergm, verbose = TRUE, ncores = 1)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{netest}.}

\item{nsims}{number of simulations to run.}

\item{nsteps}{number of time steps per simulation.}

\item{nwstats.formula}{a right-hand sided ERGM formula with the network
statistics of interest. The default is the formation formula of the
network model contained in \code{x}.}

\item{set.control.ergm}{control arguments passed to simulate.ergm (see
details).}

\item{set.control.stergm}{control arguments passed to simulate.stergm (see
details).}

\item{verbose}{print progress to the console.}

\item{ncores}{sets the number of processor cores to run multiple simulations
       on, using the \code{foreach} and \code{doParallel} implementations.}
}
\description{
Runs dynamic diagnostics on an ERGM/STERGM estimated through
             \code{netest}
}
\details{
The \code{netdx} function handles dynamic network diagnostics for network
models fit with the \code{netest} function. Given the fitted model, \code{netdx}
simulates a specified number of dynamic networks for a specified number of
time steps per simulation. The network statistics in \code{nwstats.formula}
are saved for each time step. Summary statistics for the formation model terms,
as well as dissolution model and relational duration statistics, are then
calculated for access when printing or plotting the \code{netdx} object.
}
\section{Control Arguments}{

Models fit with the full STERGM method in \code{netest} (setting \code{edapprox}
argument to \code{FALSE}) require only a call to \code{simulate.stergm}.
Control parameters for those simulations may be set using
\code{set.control.stergm} in \code{netdx}. The parameters should be input
through the \code{control.simulate.stergm()} function, with the available
parameters listed in the \code{\link{control.simulate.stergm}} help
page in the \code{tergm} package.

Models fit with the ERGM method with the edges dissolution approximation
(setting \code{edapprox} to \code{TRUE}) require a call first to
\code{simulate.ergm} for simulating an initial network and second to
\code{simulate.network} for simulating that static network forward through
time. Control parameters may be set for both processes in \code{netdx}.
For the first, the parameters should be input through the
\code{control.simulate.ergm()} function, with the available parameters listed
in the \code{\link[ergm:control.simulate.ergm]{control.simulate.ergm}} help
page in the \code{ergm} package. For the second, parameters should be input
through the \code{control.simulate.network()} function, with the available
parameters listed in the \code{\link{control.simulate.network}} help page in
the \code{tergm} package. An example is shown below.
}
\examples{
\dontrun{
# Network initialization and model parameterization
nw <- network.initialize(100, directed = FALSE)
formation <- ~ edges
dissolution <- ~ offset(edges)
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution, duration = 10)

# Estimate the model
est <- netest(
  nw,
  formation,
  dissolution,
  target.stats,
  coef.diss,
  verbose = FALSE)

# Run diagnostics
dx <- netdx(est,
  nsims = 5,
  nsteps = 500,
  nwstats.formula = ~ edges + meandeg + concurrent,
  set.control.ergm = control.simulate.ergm(MCMC.burnin = 1e6),
  set.control.stergm = control.simulate.network(MCMC.burnin.min = 1e5))

dx
plot(dx)
}
}
\seealso{
Plot these model diagnostics with \code{\link{plot.netdx}}.
}

