% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{init_tergmLite}
\alias{init_tergmLite}
\title{Initializes EpiModel netsim Object for tergmLite Simulation}
\usage{
init_tergmLite(dat)
}
\arguments{
\item{dat}{A list object containing a \code{networkDynamic} object and other
initialization information passed from \code{netsim}.}
}
\value{
Returns the list object \code{dat} and adds the element \code{el} which is
an edgelist representation of the network.  Also converts the \code{nw}
element to a \code{networkLite} representation.
}
\description{
Initializes EpiModel netsim Object for tergmLite Simulation
}
\details{
This function is typically used within the initialization modules of
\code{EpiModel} to establish the necessary infrastructure needed for
\code{tergmLite} network resimulation.  The example below demonstrates
the specific information returned.
}
\examples{
\dontrun{
library("EpiModel")
nw <- network_initialize(100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5,
                       tergmLite = TRUE)

# networkLite representation after initialization
dat <- crosscheck.net(x, param, init, control)
dat <- initialize.net(x, param, init, control)
str(dat, max.level = 1)

# Element added is el (edgelist representation of network)...
dat$el

# ... and nw is now a networkLite
dat$nw[[1]]
}

}
