% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faostat_bulk_download.R
\name{download_faostat_bulk}
\alias{download_faostat_bulk}
\title{Download bulk data from the faostat website
http://www.fao.org/faostat/en/#data}
\usage{
download_faostat_bulk(url_bulk, data_folder = "data_raw")
}
\arguments{
\item{url_bulk}{character url of the faostat bulk zip file to download}

\item{data_folder}{character path of the local folder where to download the data}
}
\description{
Note the files called "normalized" are in long format 
with a year column instead of one column for each year.
The long format is preferable for data analysis.
}
\examples{
\dontrun{
# Load global forestry data in long format
# Separated in 2 to avoid a warning about "examples lines wider than 100 characters"
# In practice you can enter the full url directly as the url_bulk argument.
url_bulk_site <- "http://fenixservices.fao.org/faostat/static/bulkdownloads"
bulk_file <- "Forestry_E_All_Data_(Normalized).zip"
url_forestry <- file.path(url_bulk_site, bulk_file)
download_faostat_bulk(url_forestry)
}
}
\author{
Paul Rougieux
}
