% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWDI.R
\name{getWDI}
\alias{getWDI}
\title{Access to World Bank WDI API}
\usage{
getWDI(
  indicator = "SP.POP.TOTL",
  name = NULL,
  startDate = 1960,
  endDate = format(Sys.Date(), "\%Y"),
  printURL = FALSE,
  outputFormat = "wide"
)
}
\arguments{
\item{indicator}{The World Bank official indicator name.}

\item{name}{The new name to be used in the column.}

\item{startDate}{The start date for the data to begin}

\item{endDate}{The end date.}

\item{printURL}{Whether the url link for the data should be printed}

\item{outputFormat}{The format of the data, can be 'long' or 'wide'.}
}
\value{
A data frame containing the desired World Bank Indicator
}
\description{
A function to extract data from the World Bank API

Please refer to \url{https://data.worldbank.org/} for any
difference between the country code system. Further details on World
Bank classification and methodology are available on that website.
}
\details{
Sometime after 2016, there was a change in the api according to 
\url{https://datahelpdesk.worldbank.org/knowledgebase/articles/889392-about-the-indicators-api-documentation}
"Version 2 (V2) of the Indicators API has been released and replaces V1 of the API. 
V1 API calls will no longer be supported. To use the V2 API, you must place v2 in the call. 
For example: \url{http://api.worldbank.org/v2/country/all/indicator/SP.POP.TOTL}.

Original (2011) source by Markus Gesmann:
\url{http://lamages.blogspot.it/2011/09/setting-initial-view-of-motion-chart-in.html}
Also available at 
\url{https://www.magesblog.com/post/2011-09-25-accessing-and-plotting-world-bank-data/}
}
\examples{
## pop.df = getWDI()
}
\seealso{
\code{\link{getFAO}}, \code{\link{getWDItoSYB}},
\code{\link{getFAOtoSYB}} 
and the wbstats package \url{https://cran.r-project.org/package=wbstats} for an implementation with many more features.
}
