% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_numeric_grid.R
\name{threshold_numeric_grid}
\alias{threshold_numeric_grid}
\title{Performs a grid search over thresholds and returns accuracy statistics for a given numeric cue}
\usage{
threshold_numeric_grid(thresholds, cue.v, criterion.v, directions = c(">",
  "<="), sens.w = 0.5, cost.each = 0, cost.outcomes = list(hi = 0, fa = 1,
  mi = 1, cr = 0), goal.threshold = "bacc")
}
\arguments{
\item{thresholds}{numeric. A vector of thresholds to consider}

\item{cue.v}{numeric. Feature values}

\item{criterion.v}{logical. Criterion values}

\item{directions}{character. Possible directions to consider}

\item{sens.w}{numeric.}

\item{cost.each}{numeric. Cost to add to each value (e.g.; cost of  the cue)}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying the costs of a hit, false alarm, miss, and correct rejection rspectively. E.g.; \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that a false alarm and miss cost 10 and 20 respectively while correct decisions have no cost.}

\item{goal.threshold}{character. A string indicating the statistic to maximize when calculting cue thresholds: "acc" = overall accuracy, "wacc" = weighted accuracy, "bacc" = balanced accuracy}
}
\description{
Performs a grid search over thresholds and returns accuracy statistics for a given numeric cue
}
