% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_apply.R
\name{fftrees_apply}
\alias{fftrees_apply}
\title{Apply an FFT to data and generate accuracy statistics}
\usage{
fftrees_apply(x, mydata = NULL, newdata = NULL, allNA.pred = FALSE)
}
\arguments{
\item{x}{An FFT to apply (as an \code{FFTrees} object).}

\item{mydata}{character. Data type to which FFT should be applied (either \code{"train"} or \code{"test"}).}

\item{newdata}{dataframe. New data to which FFT should be applied.}

\item{allNA.pred}{logical. What should be predicted if all cue values in tree are NA? Default is \code{FALSE}.}
}
\value{
A modified \code{FFTrees} object (with lists in \code{x$trees} containing information on FFT decisions and statistics).
}
\description{
\code{fftrees_apply} applies a fast-and-frugal tree (FFT, as an \code{FFTrees} object)
to a dataset and generates corresponding accuracy statistics.

\code{fftrees_apply} is called internally by the main \code{\link{FFTrees}} function
(with \code{mydata = "train"} and --- if test data exists --- \code{mydata = "test"})
and when predicting outcomes for new data by \code{\link{predict.FFTrees}}.
}
\seealso{
\code{\link{FFTrees}} for creating FFTs from and applying them to data.
}
\keyword{internal}
