% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NED_FUNCTIONS.R
\name{get_ned}
\alias{get_ned}
\title{Download and crop the 1 (~30 meter) or 1/3 (~10 meter) arc-second National Elevation Dataset.}
\usage{
get_ned(template, label, res = "1", raw.dir = "./RAW/NED/",
  extraction.dir = paste0("./EXTRACTIONS/", label, "/NED/"), force.redo = F)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve 
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{res}{A character string representing the desired resolution of the NED. '1'
indicates the 1 arc-second NED (the default), while '13' indicates the 1/3 arc-second dataset.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to './RAW/NED/'.}

\item{extraction.dir}{A character string indicating where the extracted and cropped DEM should be put.
The directory will be created if missing. Defaults to './EXTRACTIONS/NED/'.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A \code{RasterLayer} DEM cropped to the extent of the template.
}
\description{
\code{get_ned} returns a \code{RasterLayer} of elevation data cropped to a given
template study area.
}
\examples{
\dontrun{
# Extract data for the Village Ecodynamics Project 'VEPIIN' study area:
# http://village.anth.wsu.edu
vepPolygon <- polygon_from_extent(raster::extent(672800,740000,4102000,4170000), 
     proj4string='+proj=utm +datum=NAD83 +zone=12')

# Get the NED (USA ONLY)
# Returns a raster
NED <- get_ned(template=vepPolygon, label='VEPIIN')

# Plot with raster::plot
plot(NED)
}
}

