% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLCD_FUNCTIONS.R
\name{download_nlcd_tile}
\alias{download_nlcd_tile}
\title{Download a zipped tile from the National Land Cover Database.}
\usage{
download_nlcd_tile(year = 2011, dataset = "landcover", tileName, raw.dir)
}
\arguments{
\item{year}{An integer representing the year of desired NLCD product. Acceptable values are 2011 (default), 2006, and 2001.}

\item{dataset}{A character string representing type of the NLCD product. Acceptable values are landcover' (default), 'impervious', and 'canopy'.}

\item{tileName}{An character string representing tile to be downloaded. Will be of the form 'NxxWxxx', with the 'x' values as numbers.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to './RAW/NLCD/'.}
}
\value{
A character string representing the full local path of the downloaded directory.
}
\description{
Tiles are 3x3 degree.
Tiles are downloaded in zipped geotiff format. \code{download_nlcd_tile} returns the path to the downloaded zip file.
}
\keyword{internal}
