% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDC.R
\name{FDC}
\alias{FDC}
\title{Flow Duration Curve}
\usage{
FDC(flow, title, normal = FALSE, gust = TRUE)
}
\arguments{
\item{flow}{daily streamflow time series}

\item{title}{character string for plot title}

\item{normal}{boolean indicating whether to plot on normal probability 
axis (normal=TRUE) or linear probability axis (default, normal=FALSE)}

\item{gust}{boolean indicating whether to plot Gustard type curves.}
}
\description{
Produces summary screening plots of high flow, low flow, or baseflow metrics.  
Each plot shows significant temporal trends and step changes. Intended for use as 
a data quality screening tool aimed at identifying streamflow records with 
anthropogenic impacts or data inhomogeneities.
}
\examples{
data(caniapiscau)
caniapiscau <- subset(caniapiscau, !is.na(caniapiscau$Flow))
FDC(caniapiscau$Flow, title="Caniapiscau River")
}
\author{
Paul Whitfield
}
\references{
Gustard, A., Bullock, A., and Dixon, J.M. (1992). Report No. 108:
  Low flow estimation in the United Kingdom. 
  Oxfordshire, United Kingdom: Institute of Hydrology.
}

