% Generated by roxygen2 (4.0.1): do not edit by hand
\name{FB}
\alias{FB}
\title{Fuller-Burmeister estimator}
\usage{
FB(ysA, ysB, pi_A, pi_B, domains_A, domains_B, conf_level = NULL)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals.}
}
\value{
A numeric value representing population total estimation for considered values.
}
\description{
Produces estimates for population totals and means using the Fuller - Burmeister estimator from survey data obtained
 from a dual frame sampling desing. Confidence intervals are also computed, if required.
}
\details{
Fuller-Burmeister estimator of population total is given by
 \deqn{\hat{Y}_{FB} = \hat{Y}_a^A + \hat{\beta_1}\hat{Y}_{ab}^A + (1 - \hat{\beta_1})\hat{Y}_{ab}^B + \hat{Y}_b^B + \hat{\beta_2}(\hat{N}_{ab}^A - \hat{N}_{ab}^B)}
 where optimal values for \eqn{\hat{\beta}} to minimize variance of the estimator are:
 \deqn{
   \left( \begin{array}{c}
       \hat{\beta}_1\\
       \hat{\beta}_2
   \end{array} \right)
       = -
   \left( \begin{array}{cc}
       \hat{V}(\hat{Y}_{ab}^A - \hat{Y}_{ab}^B) & \widehat{Cov}(\hat{Y}_{ab}^A - \hat{Y}_{ab}^B, \hat{N}_{ab}^A - \hat{N}_{ab}^B)\\
       \widehat{Cov}(\hat{Y}_{ab}^A - \hat{Y}_{ab}^B, \hat{N}_{ab}^A - \hat{N}_{ab}^B) & \hat{V}(\hat{N}_{ab}^A - \hat{N}_{ab}^B)
   \end{array} \right)^{-1}
       \times}
 \deqn{
   \left( \begin{array}{c}
       \widehat{Cov}(\hat{Y}_a^A + \hat{Y}_b^B + \hat{Y}_{ab}^B, \hat{Y}_{ab}^A - \hat{Y}_{ab}^B)\\
       \widehat{Cov}(\hat{Y}_a^A + \hat{Y}_b^B + \hat{Y}_{ab}^B, \hat{N}_{ab}^A - \hat{N}_{ab}^B)
   \end{array} \right)
   }
 Due to Fuller-Burmeister estimator is not defined for estimating population sizes, estimation of the mean is computed as \eqn{\hat{Y}_{FB} / \hat{N}_H}, where \eqn{\hat{N}_H}
 is the estimation of the population size using Hartley estimator.
 Estimated variance for the Fuller-Burmeister estimator can be obtained through expression
 \deqn{\hat{V}(\hat{Y}_{FB}) = \hat{V}(\hat{Y}_a^A) + \hat{V}(\hat{Y}^B) +
    \hat{\beta}_1[\widehat{Cov}(\hat{Y}_a^A, \hat{Y}_{ab}^A) - \widehat{Cov}(\hat{Y}^B, \hat{Y}_{ab}^B)]}
 \deqn{ + \hat{\beta}_2[\widehat{Cov}(\hat{Y}_a^A, \hat{N}_{ab}^A) - \widehat{Cov}(\hat{Y}^B, \hat{N}_{ab}^B)]
 }
 If both first and second order probabilities are known, variances and covariances involved in calculation of \eqn{\hat{\beta}} and \eqn{\hat{V}(\hat{Y}_{FB})} are estimated using functions \code{VarHT} and \code{CovHT}, respectively. If
 only first order probabilities are known, variances are estimated using Deville's method and covariances are estimated using following expression
 \deqn{\widehat{Cov}(\hat{X}, \hat{Y}) = \frac{\hat{V}(X + Y) - \hat{V}(X) - \hat{V}(Y)}{2}}
}
\examples{
data(HouseholdsA)
dataA <- attach(HouseholdsA)
detach(HouseholdsA)
data(HouseholdsB)
dataB <- attach(HouseholdsB)
detach(HouseholdsB)
data(PiklA)
data(PiklB)

#Let calculate Fuller-Burmeister estimator for variable Clothing
FB(dataA$Clothing, dataB$Clothing, PiklA, PiklB, dataA$Domain, dataB$Domain)

#Now, let calculate Fuller-Burmeister estimator and a 90\% confidence interval
#for variable Leisure, considering only first order inclusion probabilities
FB(dataA$Leisure, dataB$Leisure, dataA$ProbA, dataB$ProbB, dataA$Domain,
dataB$Domain, 0.90)
}
\references{
Fuller, W.A. and Burmeister, L.F. (1972).
 \emph{Estimation for Samples Selected From Two Overlapping Frames} ASA Proceedings of the Social Statistics Sections, 245 - 249.
}
\seealso{
\code{\link{Hartley}} \code{\link{JackFB}}
}

