% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ggnet}
\alias{ggnet}
\title{ggnet - Plot a network with ggplot2}
\usage{
ggnet(net, mode = "fruchtermanreingold", layout.par = NULL, size = 12,
  alpha = 0.75, weight.method = "none", names = c("", ""),
  node.group = NULL, node.color = NULL, node.alpha = NULL,
  segment.alpha = NULL, segment.color = "grey", segment.label = NULL,
  segment.size = 0.25, arrow.size = 0, label.nodes = FALSE,
  label.size = size/2, top8.nodes = FALSE, trim.labels = TRUE,
  quantize.weights = FALSE, subset.threshold = 0,
  legend.position = "right", ...)
}
\arguments{
\item{net}{an object of class \code{igraph} or \code{network}. If the object is of class \code{igraph}, the \link[intergraph:asNetwork]{intergraph} package is used to convert it to class \code{network}.}

\item{mode}{a placement method from the list of modes provided in the \link[sna:gplot.layout]{sna} package. Defaults to the Fruchterman-Reingold force-directed algorithm. If \code{mode} is set to \code{"geo"} and \code{net} contains two vertex attributes called \code{"lat"} and \code{"lon"}, these are used instead for geographic networks.}

\item{layout.par}{options to the placement method, as listed in \link[sna]{gplot.layout}.}

\item{size}{size of the network nodes. Defaults to 12. If the nodes are weighted, their area is proportionally scaled up to the size set by \code{size}.}

\item{alpha}{a level of transparency for nodes, vertices and arrows. Defaults to 0.75.}

\item{weight.method}{a weighting method for the nodes. Accepts \code{"indegree"}, \code{"outdegree"} or \code{"degree"} (the default). Set to \code{"none"} to plot unweighted nodes.}

\item{names}{a character vector of two elements to use as legend titles for the node groups and node weights. Defaults to empty strings.}

\item{node.group}{a vector of character strings to label the nodes with, of the same length and order as the vertex names. Factors are converted to strings prior to plotting.}

\item{node.color}{a vector of character strings to color the nodes with, holding as many colors as there are levels in \code{node.group}. Tries to default to \code{"Set1"} if missing.}

\item{node.alpha}{transparency of the nodes. Inherits from \code{alpha}.}

\item{segment.alpha}{transparency of the vertex links. Inherits from \code{alpha}.}

\item{segment.color}{color of the vertex links. Defaults to \code{"grey"}.}

\item{segment.size}{size of the vertex links, as a vector of values or as a single value. Defaults to 0.25.}

\item{segment.label}{labels for the vertex links at mid-edges. Label size will be set to 1 / \code{segment.size}, and label alpha will inherit from \code{alpha}.}

\item{arrow.size}{size of the vertex arrows for directed network plotting, in centimeters. Defaults to 0.}

\item{label.nodes}{label nodes with their vertex names attribute. If set to \code{TRUE}, all nodes are labelled. Also accepts a vector of character strings to match with vertex names.}

\item{label.size}{size of the labels.  Defaults to \code{size / 2}.}

\item{top8.nodes}{use the top 8 nodes as node groups, colored with \code{"Set1"}. The rest of the network will be plotted as the ninth (grey) group. Experimental.}

\item{trim.labels}{removes '@', 'http://', 'www.' and the ending '/' from vertex names. Cleans up labels for website and Twitter networks. Defaults to \code{TRUE}.}

\item{quantize.weights}{break node weights to quartiles. Fails when quartiles do not uniquely identify nodes.}

\item{subset.threshold}{delete nodes prior to plotting, based on \code{weight.method} < \code{subset.threshold}. If \code{weight.method} is unspecified, total degree (Freeman's measure) is used. Defaults to 0 (no subsetting).}

\item{legend.position}{location of the captions for node colors and weights. Accepts all positions supported by ggplot2 themes. Defaults to "right".}

\item{...}{other arguments supplied to geom_text for the node labels. Arguments pertaining to the title or other items can be achieved through ggplot2 methods.}
}
\description{
Function for making a network plot from an object of class \code{network} or \code{igraph}, using ggplot2.  Please visit \url{http://github.com/briatte/ggnet} for the latest development and descriptions about ggnet.
}
\details{
The \code{weight.method} argument produces visually scaled nodes that are proportionally sized to their unweighted degree. To compute weighted centrality or degree measures, see Tore Opsahl's \code{\link[tnet]{tnet}} package.
}
\examples{
require(network)
# make toy random network
x                  <- 10
ndyads             <- x * (x - 1)
density            <- x / ndyads
nw.mat             <- matrix(0, nrow = x, ncol = x)
dimnames(nw.mat)   <- list(1:x, 1:x)
nw.mat[row(nw.mat) != col(nw.mat)] <- runif(ndyads) < density
nw.mat
rnd <- network::network(nw.mat)
rnd

# random network
pRnd <- ggnet(rnd, label.nodes = TRUE, alpha = 1, color = "white", segment.color = "grey10")
# pRnd

# random groups
category = LETTERS[rbinom(x, 4, .5)]
ggnet(rnd, label.nodes = TRUE, color = "white", segment.color = "grey10", node.group = category)

# city and service firms data from the UCIrvine Network Data Repository
data(cityServiceFirms, package = "GGally")

# plot cities, firms and law firms
type = cityServiceFirms \%v\% "type"
type = ifelse(grepl("City|Law", type), gsub("I+", "", type), "Firm")
pRnd <- ggnet(cityServiceFirms, mode = "kamadakawai", alpha = .2, node.group = type,
      label.nodes = c("Paris", "Beijing", "Chicago"), color = "darkred")
# pRnd
}
\author{
Moritz Marbach \email{mmarbach@mail.uni-mannheim.de} and Francois Briatte \email{f.briatte@ed.ac.uk}
}
\seealso{
\code{\link[sna]{gplot}} in the \link[sna:gplot]{sna} package
}

