% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getDesign.R
\name{getDesign}
\alias{getDesign}
\title{Get design corresponding to an objective target}
\usage{
getDesign(model, target, lower, upper, optimcontrol = NULL)
}
\arguments{
\item{model}{list of objects of class \code{\link[DiceKriging]{km}}, one for each objective functions,}

\item{target}{vector corresponding to the desired output in the objective space,}

\item{lower}{vector of lower bounds for the variables to be optimized over,}

\item{upper}{vector of upper bounds for the variables to be optimized over,}

\item{optimcontrol}{optional list of control parameters for optimization of the selected infill criterion.
      "\code{method}" set the optimization method; one can
       choose between "\code{discrete}", "\code{pso}" and "\code{genoud}". For each method, further parameters can be set.\cr
       For "\code{discrete}", one has to provide the argument "\code{candidate.points}". \cr
       For "\code{pso}", one can control the maximum number of iterations "\code{maxit}" (\code{400}) and the population size "\code{s}"
       (default :  \code{max(20, floor(10+2*sqrt(length(dim))))} (see \code{\link[pso]{psoptim}}). \cr
       For "\code{genoud}", one can control, among others, "\code{pop.size}" (default :  \code{[N = 3*2^dim} for \code{dim < 6} and  \code{N = 32*dim} otherwise]),
"\code{max.generations}" (\code{12}), "\code{wait.generations}" (\code{2}), "\code{BFGSburnin}" (\code{2}), \code{BFGSmaxit} (\code{N}) and \code{solution.tolerance} (\code{1e-21})
 of function "\code{genoud}" (see \code{\link[rgenoud]{genoud}}). Numbers into brackets are the default values.}
}
\value{
A list with components:
\itemize{
\item \code{par}: best design found,
\item \code{value}: probabilitity that the design dominates the target,
\item \code{mean}: kriging mean of the objectives at the design,
\item \code{sd}: prediction standard deviation at the design.
}
}
\description{
Find the design that maximizes the probability of dominating a target given by the user.
}
\examples{
\dontrun{

#---------------------------------------------------------------------------
# Example of interactive optimization
#---------------------------------------------------------------------------

set.seed(25468)
library(DiceDesign)

d <- 2
n.obj <- 2
fun <- "P1"
n.grid <- 51
test.grid <- expand.grid(seq(0, 1, length.out = n.grid), seq(0, 1, length.out = n.grid))
nappr <- 20
design.grid <- round(maximinESE_LHS(lhsDesign(nappr, d, seed = 42)$design)$design, 1)
response.grid <- t(apply(design.grid, 1, fun))
paretoFront <- t(nondominated_points(t(response.grid)))
mf1 <- km(~., design = design.grid, response = response.grid[,1])
mf2 <- km(~., design = design.grid, response = response.grid[,2])
model <- list(mf1, mf2)
lower <- rep(0, d); upper <- rep(1, d)

sol <- GParetoptim(model, fun, crit = "SUR", nsteps = 5, lower = lower, upper = upper)

plotGPareto(sol)

target1 <- c(15, -25)
points(x = target1[1], y = target1[2], col = "black", pch = 13)

nDesign <- getDesign(sol$lastmodel, target = target1, lower = rep(0, d), upper = rep(1, d))
points(t(nDesign$mean), col = "green", pch = 20)

target2 <- c(48, -27)
points(x = target2[1], y = target2[2], col = "black", pch = 13)
nDesign2 <- getDesign(sol$lastmodel, target = target2, lower = rep(0, d), upper = rep(1, d))
points(t(nDesign2$mean), col = "darkgreen", pch = 20)
}
}

