% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_column_labels.R
\name{set_column_labels}
\alias{set_column_labels}
\title{Add [Hmisc::label()] to multiple columns}
\usage{
set_column_labels(x, ...)
}
\arguments{
\item{x}{The data frame that we want to label}

\item{...}{Variable names with their intended label, e.g. `mpg = "Miles per gallon"`.}
}
\value{
The original data.frame
}
\description{
Add label attribute using `dplyr` syntax using the [Hmisc::label()]
}
\examples{
library(magrittr)
data(mtcars)
mtcars_with_labels <- mtcars \%>\%
  set_column_labels(mpg = "Gas",
                    cyl = "Cylinders",
                    hp = "Strength")
Hmisc::label(mtcars_with_labels$mpg)
}
\seealso{
Other Hmisc helpers: 
\code{\link{set_column_units}()}
}
\concept{Hmisc helpers}
