% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{WH.regression.two.components.predict}
\alias{WH.regression.two.components.predict}
\title{Multiple regression analysis for  histogram variables based on a two component model and L2 Wasserstein distance}
\usage{
WH.regression.two.components.predict(data, parameters)
}
\arguments{
\item{data}{A MatH object (a matrix of distributionH) explantory part.}

\item{parameters}{A named vector with the parameter from a \code{WH.regression.two.components} model}
}
\value{
a \code{MatH}  object, the predicted histograms
}
\description{
Predict distributions using the results of a regression done with \code{WH.regression.two.components} function.
}
\examples{
# do regression
 model.parameters=WH.regression.two.components(data = BLOOD,Yvar = 1, Xvars= c(2:3))
# do prediction
Predicted.BLOOD=WH.regression.two.components.predict(data = BLOOD[,2:3],parameters=model.parameters)
}
\references{
Irpino A, Verde R (in press 2015). Linear regression for numeric symbolic variables: a least squares approach 
based on Wasserstein Distance. ADVANCES IN DATA ANALYSIS AND CLASSIFICATION, ISSN: 1862-5347, DOI:10.1007/s11634-015-0197-7 \cr
An extended version is available  on arXiv repository arXiv:1202.1436v2 \url{http://arxiv.org/abs/1202.1436v2}
}
