\name{NMR_experiment}
\alias{NMR_experiment}
\title{
Stimulated NMR Experiment
}
\description{
This function is designed to stimulate NMR experiment.
}
\usage{
NMR_experiment(t.stimulated_metabolites_1, s_data_x, s_data_y, variance_frequency, variance_frequency_interval, SNR , TD , SWH, SFO1, O1, fid_save_path )
}

\arguments{
  \item{t.stimulated_metabolites_1}{
This argument defines the data set of selected metabolites, internal standard (DSS), and respective concentration which are generated by function "select_metabolites( )".
}
  \item{s_data_x}{
This argument provides the information about the targeted metabolites' chemical shifts and the intramolecular resonance signals' intensity ratios.  It must be specified by users or the code "data(space_x)".

}
  \item{s_data_y}{
This argument provides the information about the targeted metabolites' molecular constitution and the experimental conditions of reference NMR spectra.  It must be specified by users or the code "data(lists_metabolites)".
}
  \item{variance_frequency}{
The resonance frequencies are not all the same as the reference frequencies, even for the same condition. This argument defines the variance of the resonance frequency.  The unit is ppm.
}
  \item{variance_frequency_interval}{
An important characteristic parameter in NMR is the frequency interval of the resonance frequencies. This argument defines the variance of the frequency intervals.  The unit is ppm.
}
  \item{SNR}{
The signal to noise Ratio.  It is the SNR of the minimal resonance line of NMR spectra.  Note that this is peak SNR.
}
  \item{TD}{
Time domain data size. It is an NMR experiment parameter. Please refer to BRUKER NMR Guide.
}
  \item{SWH}{
The spectral width of NMR experiment. The unit is Hz. It is an NMR experiment parameter. Please refer to BRUKER NMR Guide.
}
  \item{SFO1}{
The transmitter frequency. The unit is MHz. It is an NMR experiment parameter. Please refer to BRUKER NMR Guide.
}
  \item{O1}{
The transmitter frequency offset in Hz. It is an NMR experiment parameter. this value can be obtained from NMR spectra.
}
  \item{fid_save_path}{
The file path used to save the stimulated FID file.  The file  is a binary file with the format of BRUKER FID.
}
}
\details{
In order to validate our algorithm, the simulated NMR data are used firstly.  This function is designed to generate the simulated NMR FID.
}
\value{
The value returned is a dataframe which give the information about the simulated acquisition time, the time domain data size, the spectral width, The transmitter frequency in MHz and The transmitter frequency offset in Hz.

}

\author{
Xu Song. China. 
}

\examples{
data(lists_metabolites)


stimulated_metabolites<-select_metabolites(n_metabolites=10,
                             s.lists_metabolites=lists_metabolites
                             )

data(space_x)

NMR_experiment(
                         t.stimulated_metabolites_1=stimulated_metabolites,
                         s_data_x=space_x,
                         s_data_y=lists_metabolites,
                         variance_frequency=10,
                         variance_frequency_interval=2,
                         SNR= 100, 
                         TD=65536,
                         SWH=6218.90547263682,
                         SFO1=400.131880611,
                         O1=1880.611,
                         fid_save_path="fid_stimulate"
                         )
}
\keyword{ function }
